<?php
/**
 * Tags
 *
 * @package     AutomatorWP\UserFeedback\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Survey tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_userfeedback_get_survey_tags() {

    return array(
        'survey_title' => array(
            'label'     => __( 'Survey Title', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The survey title',
        ),
        'survey_question' => array(
            'label'     => __( 'Survey Question', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The survey question',
        ),
        'survey_first_response' => array(
            'label'     => __( 'Survey First Response', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The survey first response',
        ),
        'survey_all_responses' => array(
            'label'     => __( 'All survey responses', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'All survey responses',
        ),
        'survey_id' => array(
            'label'     => __( 'Survey ID', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The survey ID',
        ),
        'user_ip' => array(
            'label'     => __( 'User IP Address', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The user IP Address',
        ),
    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_userfeedback_get_trigger_survey_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'userfeedback' ) {
        return $replacement;
    }
    
    switch( $tag_name ) {
        case 'survey_title':
            $replacement = automatorwp_get_log_meta( $log->id, 'survey_title', true );
            break;
        case 'survey_question':
            $replacement = automatorwp_get_log_meta( $log->id, 'survey_question', true );
            break;
        case 'survey_first_response':
            $replacement = automatorwp_get_log_meta( $log->id, 'survey_first_response', true );
            break;
        case 'survey_all_responses':
            $replacement = automatorwp_get_log_meta( $log->id, 'survey_all_responses', true );
            break;
        case 'survey_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'survey_id', true );
            break;
        case 'user_ip':
            $replacement = automatorwp_get_log_meta( $log->id, 'user_ip', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_userfeedback_get_trigger_survey_tag_replacement', 10, 6 );